
'3D Maze
#include "colors.inc"
option base 0
dim integer width, height, done, i
dim integer x, y, xt, yt, currentx, currenty, oldx, oldy
'dim string maze$(2280, 1140) length 1
dim string maze$(100, 50) length 1, ch$ length 1 'Compass Heading
dim string draw$ = "Y" length 1, wc$ length 1 = chr$(219) 'Wall character

cls
mode 1, 16
color Indigo

'must be even
width = 48 : height = 24

'fill array
for x = 0 to width
  for y = 0 to height
    maze$(x, y) = wc$
  next y
next x

'Initial start location
currentx = int(rnd * (width - 1))
currenty = int(rnd * (height - 1))

'value must be odd
if currentx mod 2 = 0 then currentx = currentx + 1
if currenty mod 2 = 0 then currenty = currenty + 1
maze$(x, y) = " "

'generate maze
done = 0
do while done = 0
  for i = 0 to 99
    oldx = currentx
    oldy = currenty

    'move in random direction
    select case int(rnd * 4)
      case 0
        if currentx + 2 < width then currentx = currentx + 2
      case 1
        if currenty + 2 < height then currenty = currenty + 2
      case 2
        if currentx - 2 > 0 then currentx = currentx - 2
      case 3
        if currenty - 2 > 0 then currenty = currenty - 2
    end select

    'if cell is unvisited, then connect it
    if maze$(currentx, currenty) = wc$ then
      maze$(currentx, currenty) = " "
      maze$(int((currentx + oldx) / 2), ((currenty + oldy) / 2)) = " "
    endif
  next i

  'check if all cells are visited
  done = 1
  for x = 1 to width - 1 step 2
    for y = 1 to height - 1 step 2
      if maze$(x, y) = wc$ then done = 0
    next y
  next x
loop

'Draw the view starting looking South from the first available empty square at the
'Northwestern most edge of the maze.  The exit will be the Southeastern most empty square.
'Perhaps show a ladder going down at exit and have user press the D key to descend/exit maze.
'Perhaps show a ladder going up at entrance and have user press the U key to go up/exit maze.
x = 1 'x = 0, y = 0 will always be a wall. x = 1, y = 1 will always be empty space
y = 1 
ch$ = "S"
'maze$(1, 1) = "u"
maze$(1, 1) = "x"
maze$(width - 1, height - 1) = "d"

draw_2d_maze()
'draw_3d_maze()

do
  if keydown(0) = 1 then 'user presses just one key
    if keydown(1) = 32 then ' User presses space bar
      draw_3d_maze() 'redraw view
    elseif keydown(1) = 130 then 'User presses cursor left key
      select case ch$
        case "N"
          ch$ = "W" 
        case "W"
          ch$ = "S" 
        case "S"
          ch$ = "E" 
        case "E"
          ch$ = "N" 
      end select
      draw_3d_maze() 
    elseif keydown(1) = 131 then 'User presses the cursor right key
      select case ch$
        case "N"
          ch$ = "E" 
        case "E"
          ch$ = "S" 
        case "S"
          ch$ = "W" 
        case "W"
          ch$ = "N" 
      end select
      draw_3d_maze() 
    elseif keydown(1) = 128 then 'User presses the cursor forward key
      select case ch$
        case "W"
          if maze$(x - 1, y) <> wc$ then 'There is NO wall blocking the path
            maze$(x - 1, y) = "x" 'Update the location of the user
            maze$(x, y) = " " 'Reset the former loccation of the user to empty cell 'deal with ladder
            x = x - 1 
          endif
        case "E"
          if maze$(x + 1, y) <> wc$ then 
            maze$(x + 1, y) = "x"    
            maze$(x, y) = " "
            x = x + 1
          endif
        case "N"
          if maze$(x, y - 1) <> wc$ then 
            maze$(x, y - 1) = "x"
            maze$(x, y) = " " 
            y = y - 1
          endif
        case "S"
          if maze$(x, y + 1) <> wc$ then
            maze$(x, y + 1) = "x"
            maze$(x, y) = " "
            y = y + 1
          endif
      end select
      if maze$(1, 1) = " " then maze$(1, 1) = "u"
      if maze$(width - 1, height - 1 ) = " " then maze(width - 1, height - 1 ) = "d"
      draw_3d_maze() 
    elseif keydown(1) = 129 then 'User presses the cursor backward key
      select case ch$
        case "W"
          if maze$(x + 1, y) <> wc$ then
            maze$(x + 1, y ) = "x"
            maze$(x, y) = " "
            x = x + 1
          endif
        case "E"
          if maze$(x - 1, y) <> wc$ then 
            maze$(x - 1, y) = "x"
            maze$(x, y) = " "
            x = x - 1
          endif
        case "N"
          if maze$(x, y + 1) <> wc$ then 
            maze$(x, y + 1) = "x"
            maze$(x, y) = " "
            y = y + 1
          endif
        case "S"
          if maze$(x, y - 1) <> wc$ then  
            maze$(x, y - 1) = "x"
            maze$(x, y) = " "
            y = y - 1
          endif
      end select 
      if maze$(1, 1) = " " then maze$(1, 1) = "u"
      if maze$(width - 1, height - 1 ) = " " then maze(width - 1, height - 1 ) = "d"
      draw_3d_maze() 
    elseif keydown(1) = 109 then 'user presses M key to see the map / top view of the maze
      draw_2d_maze()
      'draw_3d_maze() 
    endif
  endif
loop

sub draw_2d_maze
  cls
  for yt = 0 to height
    for xt = 0 to width
      if maze$(xt, yt) = "x" then 'x represents the user's location within the maze
        select case ch$
          case "N"
            print chr$(146); 'show the arrow pointing North character
          case "S"
            print chr$(147);
          case "E"
            print chr$(148);
          case "W"
            print chr$(149);
        end select
      else
        print maze$(xt, yt);
      endif
    next xt
    print
  next yt
  do : loop while inkey$ = "" 'wait for user to press a key
end sub

sub draw_3d_maze
  cls
  '0 distant, cube in which the user is standing
  select case ch$
    case "N"
      xt = x : yt = y - 1
    case "S" 
      xt = x : yt = y + 1
    case "W"
      xt = x - 1 : yt = y
    case "E"
      xt = x + 1 : yt = y
  end select
  if xt < 0 then xt = 0
  if yt < 0 then yt = 0
  if maze$(xt, yt) = wc$ then
    line   0,   0, 799,   0 '0T wall immediately ahead, do not draw 1-8 blocks in the distance
    line   0, 599, 799, 599 '0B wall 
    draw$ = "N"
  else
    draw$ = "Y"
  endif  
  line   0,   0,   0, 599 '0L always draw
  line 798,   0, 798, 599 '0R always draw

  '1 distant
  if draw$ = "Y" then
    select case ch$
      case "N"
        xt = x - 1 : yt = y - 1       
      case "S"
        xt = x + 1 : yt = y + 1
      case "W"  
        xt = x - 1 : yt = y + 1
      case "E"
        xt = x + 1 : yt = y - 1
    end select
    if maze$(xt, yt) = wc$ then
      line   0,   0, 200, 150 '1DUL wall to the left at 1 level
      line   0, 599, 200, 450 '1DBL 
    endif

    select case ch$
      case "N"
        xt = x + 1 : yt = y - 1
      case "S"
        xt = x - 1 : yt = y + 1
      case "W"
        xt = x - 1 : yt = y - 1
      case "E"
        xt = x + 1 : yt = y + 1
    end select
    if maze$(xt, yt) = wc$ then
      line 799,   0, 600, 150 '1DUR wall to the right at 1 level
      line 799, 599, 600, 450 '1DBR 
    endif

    select case ch$
      case "N"
        xt = x : yt = y - 2 
      case "S"
        xt = x : yt = y + 2
      case "W"
        xt = x - 2 : yt = y
      case "E"
        xt = x + 2 : yt = y
    end select   
    if xt < 0 then xt = 0
    if yt < 0 then yt = 0
    if maze$(xt, yt) = wc$ then
      line 200, 150, 600, 150 '1T wall, do not draw 2-8 blocks
      line 200, 450, 600, 450 '1B 
      draw$ = "N"
    endif

    line 200, 150, 200, 450 '1L draw unless wall at 0 block
    line 600, 150, 600, 450 '1R 

    select case ch$
      case "N"
        xt = x - 1 : yt = y - 1
      case "S"
        xt = x + 1 : yt = y + 1
      case "W"
        xt = x - 1 : yt = y + 1 
      case "E"
        xt = x + 1 : yt = y - 1
    end select
    if maze$(xt, yt) <> wc$ then 'not a block, so empty space or up or down ladder
      line 200, 150,   0, 150 '1TL 
      line 200, 450,   0, 450 '1BL
    endif

    select case ch$
      case "N"
        xt = x + 1 : yt = y - 1
      case "S"
        xt = x - 1 : yt = y + 1
      case "W"
        xt = x - 1 : yt = y - 1
      case "E"
        xt = x + 1 : yt = y + 1
    end select  
    if maze$(xt, yt) <> wc$ then 'not a block, so empty space or up or down ladder
      line 600, 150, 799, 150 '1TR
      line 600, 450, 799, 450 '1BR
    endif
  endif

  '2 distant
  if draw$ = "Y" then
    select case ch$
      case "N"
        xt = x - 1 : yt = y - 2
      case "S"
        xt = x + 1 : yt = y + 2
      case "W"
        xt = x - 2 : yt = y + 1
      case "E"
        xt = x + 2 : yt = y - 1
    end select
    if maze$(xt, yt) = wc$ then
      line 200, 150, 300, 225 '2DUL wall to the left at 2 level
      line 200, 450, 300, 375 '2DBL
    endif

    select case ch$
      case "N"
        xt = x + 1 : yt = y - 2
      case "S"
        xt = x - 1 : yt = y + 2
      case "W"
        xt = x - 2 : yt = y - 1
      case "E"
        xt = x + 2 : yt = y + 1
    end select
    if maze$(xt, yt) = wc$ then
      line 600, 150, 500, 225 '2DUR wall to the right at 2 level
      line 600, 450, 500, 375 '2DBR 
    endif

    select case ch$
      case "N"
        xt = x : yt = y - 3
      case "S"
        xt = x : yt = y + 3
      case "W"
        xt = x - 3 : yt = y
      case "E"
        xt = x + 3 : yt = y
    end select
    if xt < 0 then xt = 0
    if yt < 0 then yt = 0
    if maze$(xt, yt) = wc$ then
      line 300, 225, 500, 225 '2T wall, do not draw 3-8 blocks
      line 300, 375, 500, 375 '2B
      draw$ = "N"
    endif

    line 300, 225, 300, 375 '2L draw unless wall at block 0 or 1
    line 500, 225, 500, 375 '2R

    select case ch$
      case "N"
        xt = x - 1 : yt = y - 2
      case "S"
        xt = x + 1 : yt = y + 2
      case "W"
        xt = x - 2 : yt = y + 1
      case "E"
        xt = x + 2 : yt = y - 1  
    end select
    if maze$(xt, yt) <> wc$ then
      line 300, 225, 200, 225 '2TL
      line 300, 375, 200, 375 '2BL
    endif

    select case ch$
      case "N"
        xt = x + 1 : yt = y - 2
      case "S"
        xt = x - 1 : yt = y + 2
      case "W"
        xt = x - 2 : yt = y - 1
      case "E"
        xt = x + 2 : yt = y + 1
    end select    
    if maze$(xt, yt) <> wc$ then
      line 500, 225, 600, 225 '2TR
      line 500, 375, 600, 375 '2BR
    endif
  endif

  '3 distant
  if draw$ = "Y" then
    select case ch$
      case "N"
        xt = x - 1 : yt = y - 3
      case "S"
        xt = x + 1 : yt = y + 3
      case "W"
        xt = x - 3 : yt = y + 1
      case "E"
        xt = x + 3 : yt = y - 1
    end select
    if maze$(xt, yt) = wc$ then
      line 300, 225, 350, 262 '3DUL wall to the left at 3 level
      line 300, 375, 350, 338 '3DBL 
    endif  

    select case ch$
      case "N"
        xt = x + 1 : yt = y - 3
      case "S"
        xt = x - 1 : yt = y + 3
      case "W"
        xt = x - 3 : yt = y - 1
      case "E"
        xt = x + 3 : yt = y + 1
    end select
    if maze$(xt, yt) = wc$ then
      line 500, 225, 450, 262 '3DUR wall to the right at 3 level
      line 500, 375, 450, 338 '3DBR 
    endif

    select case ch$
      case "N"
        xt = x : yt = y - 4
      case "S"
        xt = x : yt = y + 4
      case "W"
        xt = x - 4 : yt = y
      case "E"
        xt = x + 4 : yt = y
    end select        
    if xt < 0 then xt = 0
    if yt < 0 then yt = 0
    if maze$(xt, yt) = wc$ then 
      line 350, 262, 450, 262 '3T wall, do not draw 4-8 blocks
      line 350, 338, 450, 338 '3B wall
    draw$ = "N" 
    endif

    line 350, 262, 350, 338 '3L draw unless wall at block 0 or 1 or 2
    line 450, 262, 450, 338 '3R 

    select case ch$
      case "N"
        xt = x - 1 : yt = y - 3
      case "S"
        xt = x + 1 : yt = y + 3
      case "W"
        xt = x - 3 : yt = y + 1
      case "E"
        xt = x + 3 : yt = y - 1
    end select
    if maze$(xt, yt) <> wc$ then
      line 350, 262, 300, 262 '3TL 
      line 350, 338, 300, 338 '3BL
    endif

    select case ch$
      case "N"
        xt = x + 1 : yt = y - 3
      case "S"
        xt = x - 1 : yt = y + 3
      case "W"
        xt = x - 3 : yt = y - 1
      case "E"
        xt = x + 3 : yt = y + 1
    end select    
    if maze$(xt, yt) <> wc$ then
      line 450, 262, 500, 262 '3TR
      line 450, 338, 500, 338 '3BR
    endif
  endif

  '4 distant
  if draw$ = "Y" then
    select case ch$
      case "N"
        xt = x - 1 : yt = y - 4
      case "S"
        xt = x + 1 : yt = y + 4
      case "W"
        xt = x - 4 : yt = y + 1
      case "E"
        xt = x + 4 : yt = y - 1
    end select
    if maze$(xt, yt) = wc$ then
      line 350, 262, 375, 281 '4DUL wall to the left at 4 level
      line 350, 338, 375, 319 '4DBL     
    endif  

    select case ch$
      case "N"
        xt = x + 1 : yt = y - 4
      case "S"
        xt = x - 1 : yt = y + 4
      case "W"
        xt = x - 4 : yt = y - 1
      case "E"
        xt = x + 4 : yt = y + 1
    end select
    if maze$(xt, yt) = wc$ then
      line 450, 262, 425, 281 '4DUR wall to the right at 4 level
      line 450, 338, 425, 319 '4DBR      
    endif

    select case ch$
      case "N"
        xt = x : yt = y - 5
      case "S"
        xt = x : yt = y + 5
      case "W"
        xt = x - 5 : yt = y
      case "E"
        xt = x + 5 : yt = y
    end select        
    if xt < 0 then xt = 0
    if yt < 0 then yt = 0
    if maze$(xt, yt) = wc$ then 
      line 375, 281, 425, 281 '4T wall, do not draw 5-8 blocks
      line 375, 319, 425, 319 '4B 
    draw$ = "N" 
    endif

    line 375, 281, 375, 319 '4L draw unless wall at block 0-3
    line 425, 281, 425, 319 '4R

    select case ch$
      case "N"
        xt = x - 1 : yt = y - 4
      case "S"
        xt = x + 1 : yt = y + 4
      case "W"
        xt = x - 4 : yt = y + 1
      case "E"
        xt = x + 4 : yt = y - 1
    end select
    if maze$(xt, yt) <> wc$ then
      line 375, 281, 350, 281 '4TL
      line 375, 319, 350, 319 '4BL      
    endif

    select case ch$
      case "N"
        xt = x + 1 : yt = y - 4
      case "S"
        xt = x - 1 : yt = y + 4
      case "W"
        xt = x - 4 : yt = y - 1
      case "E"
        xt = x + 4 : yt = y + 1
    end select    
    if maze$(xt, yt) <> wc$ then
      line 425, 281, 450, 281 '4TR
      line 425, 319, 450, 319 '4BR      
    endif
  endif

  '5 distant
  if draw$ = "Y" then
    select case ch$
      case "N"
        xt = x - 1 : yt = y - 5
      case "S"
        xt = x + 1 : yt = y + 5
      case "W"
        xt = x - 5 : yt = y + 1
      case "E"
        xt = x + 5 : yt = y - 1
    end select
    if maze$(xt, yt) = wc$ then
      line 375, 281, 387, 290 '5DUL wall to the left at 5 level
      line 375, 319, 387, 310 '5DBL
    endif  

    select case ch$
      case "N"
        xt = x + 1 : yt = y - 5
      case "S"
        xt = x - 1 : yt = y + 5
      case "W"
        xt = x - 5 : yt = y - 1
      case "E"
        xt = x + 5 : yt = y + 1
    end select
    if maze$(xt, yt) = wc$ then
      line 425, 281, 413, 290 '5DUR wall to the right at 5 level
      line 425, 319, 413, 310 '5DBR
    endif

    select case ch$
      case "N"
        xt = x : yt = y - 6
      case "S"
        xt = x : yt = y + 6
      case "W"
        xt = x - 6 : yt = y
      case "E"
        xt = x + 6 : yt = y
    end select        
    if xt < 0 then xt = 0
    if yt < 0 then yt = 0
    if maze$(xt, yt) = wc$ then 
      line 387, 290, 413, 290 '5T wall, do not draw 6-8 blocks
      line 387, 310, 413, 310 '5B wall
    draw$ = "N" 
    endif

    line 387, 290, 387, 310 '5L draw unless wall at block 0-4
    line 413, 290, 413, 310 '5R

    select case ch$
      case "N"
        xt = x - 1 : yt = y - 5
      case "S"
        xt = x + 1 : yt = y + 5
      case "W"
        xt = x - 5 : yt = y + 1
      case "E"
        xt = x + 5 : yt = y - 1
    end select
    if maze$(xt, yt) <> wc$ then
      line 387, 290, 375, 290 '5TL
      line 387, 310, 375, 310 '5BL      
    endif

    select case ch$
      case "N"
        xt = x + 1 : yt = y - 5
      case "S"
        xt = x - 1 : yt = y + 5
      case "W"
        xt = x - 5 : yt = y - 1
      case "E"
        xt = x + 5 : yt = y + 1
    end select    
    if maze$(xt, yt) <> wc$ then
      line 413, 290, 425, 290 '5TR
      line 413, 310, 425, 310 '5BR      
    endif
  endif

  '6 distant
  if draw$ = "Y" then
    select case ch$
      case "N"
        xt = x - 1 : yt = y - 6
      case "S"
        xt = x + 1 : yt = y + 6
      case "W"
        xt = x - 6 : yt = y + 1
      case "E"
        xt = x + 6 : yt = y - 1
    end select
    if maze$(xt, yt) = wc$ then
      line 387, 290, 393, 295 '6DUL wall to the left at 6 level
      line 387, 310, 393, 305 '6DBL 
    endif  

    select case ch$
      case "N"
        xt = x + 1 : yt = y - 6
      case "S"
        xt = x - 1 : yt = y + 6
      case "W"
        xt = x - 6 : yt = y - 1
      case "E"
        xt = x + 6 : yt = y + 1
    end select
    if maze$(xt, yt) = wc$ then
      line 413, 290, 407, 295 '6DUR wall to the right at 6 level
      line 413, 310, 407, 305 '6DBR
    endif

    select case ch$
      case "N"
        xt = x : yt = y - 7
      case "S"
        xt = x : yt = y + 7
      case "W"
        xt = x - 7 : yt = y
      case "E"
        xt = x + 7 : yt = y
    end select        
    if xt < 0 then xt = 0
    if yt < 0 then yt = 0
    if maze$(xt, yt) = wc$ then 
      line 393, 295, 407, 295 '6T wall, do not draw 7-8 blocks
      line 393, 305, 407, 305 '6B       
    draw$ = "N" 
    endif

    line 393, 295, 393, 305 '6L draw unless wall at block 0-5
    line 407, 295, 407, 305 '6R 

    select case ch$
      case "N"
        xt = x - 1 : yt = y - 6
      case "S"
        xt = x + 1 : yt = y + 6
      case "W"
        xt = x - 6 : yt = y + 1
      case "E"
        xt = x + 6 : yt = y - 1
    end select
    if maze$(xt, yt) <> wc$ then
      line 393, 295, 387, 295 '6TL
      line 393, 305, 387, 305 '6BL      
    endif

    select case ch$
      case "N"
        xt = x + 1 : yt = y - 6
      case "S"
        xt = x - 1 : yt = y + 6
      case "W"
        xt = x - 6 : yt = y - 1
      case "E"
        xt = x + 6 : yt = y + 1
    end select    
    if maze$(xt, yt) <> wc$ then
      line 407, 295, 413, 295 '6TR
      line 407, 305, 413, 305 '6BR      
    endif
  endif
      
  '7 distant
  if draw$ = "Y" then
    select case ch$
      case "N"
        xt = x - 1 : yt = y - 7
      case "S"
        xt = x + 1 : yt = y + 7
      case "W"
        xt = x - 7 : yt = y + 1
      case "E"
        xt = x + 7 : yt = y - 1
    end select
    if maze$(xt, yt) = wc$ then
      line 393, 295, 396, 297 '7DUL wall to the left at 7 level
      line 393, 305, 396, 303 '7DBL
    endif  

    select case ch$
      case "N"
        xt = x + 1 : yt = y - 7
      case "S"
        xt = x - 1 : yt = y + 7
      case "W"
        xt = x - 7 : yt = y - 1
      case "E"
        xt = x + 7 : yt = y + 1
    end select
    if maze$(xt, yt) = wc$ then
      line 407, 295, 404, 297 '7DUR wall to the right at 7 level
      line 407, 305, 404, 303 '7DBR
    endif

    select case ch$
      case "N"
        xt = x : yt = y - 8
      case "S"
        xt = x : yt = y + 8
      case "W"
        xt = x - 8 : yt = y
      case "E"
        xt = x + 8 : yt = y
    end select        
    if xt < 0 then xt = 0
    if yt < 0 then yt = 0
    if maze$(xt, yt) = wc$ then 
      line 396, 297, 404, 297 '7T wall, do not draw 8 block
      line 396, 303, 404, 303 '7B 
    draw$ = "N" 
    endif

    line 396, 297, 396, 303 '7L draw unless wall at block 0-6
    line 404, 297, 404, 303 '7R draw unless wall of block 0-6

    select case ch$
      case "N"
        xt = x - 1 : yt = y - 7
      case "S"
        xt = x + 1 : yt = y + 7
      case "W"
        xt = x - 7 : yt = y + 1
      case "E"
        xt = x + 7 : yt = y - 1
    end select
    if maze$(xt, yt) <> wc$ then
      line 396, 297, 393, 297 '7TL
      line 396, 303, 393, 303 '7BL      
    endif

    select case ch$
      case "N"
        xt = x + 1 : yt = y - 7
      case "S"
        xt = x - 1 : yt = y + 7
      case "W"
        xt = x - 7 : yt = y - 1
      case "E"
        xt = x + 7 : yt = y + 1
    end select    
    if maze$(xt, yt) <> wc$ then
      line 404, 297, 407, 297 '7TR
      line 404, 303, 407, 303 '7BR
    endif
  endif
    
  '8 distant
  if draw$ = "Y" then
    select case ch$
      case "N"
        xt = x - 1 : yt = y - 8
      case "S"
        xt = x + 1 : yt = y + 8
      case "W"
        xt = x - 8 : yt = y + 1
      case "E"
        xt = x + 8 : yt = y - 1
    end select
    if maze$(xt, yt) = wc$ then
      line 396, 297, 398, 299 '8DUL wall to the left at 8 level
      line 396, 303, 398, 301 '8DBL
    endif  

    select case ch$
      case "N"
        xt = x + 1 : yt = y - 8
      case "S"
        xt = x - 1 : yt = y + 8
      case "W"
        xt = x - 8 : yt = y - 1
      case "E"
        xt = x + 8 : yt = y + 1
    end select
    if maze$(xt, yt) = wc$ then
      line 404, 297, 402, 299 '8DUR wall to the right at 8 level
      line 404, 303, 402, 301 '8DBR 
    endif

    select case ch$
      case "N"
        xt = x : yt = y - 9
      case "S"
        xt = x : yt = y + 9
      case "W"
        xt = x - 9 : yt = y
      case "E"
        xt = x + 9 : yt = y
    end select        
    if xt < 0 then xt = 0
    if yt < 0 then yt = 0
    if maze$(xt, yt) = wc$ then 
      line 398, 299, 402, 299 '8T wall
      line 398, 301, 402, 301 '8B wall      
    draw$ = "N" 
    endif

    line 398, 299, 398, 301 '8L draw unless wall at block 0-7
    line 402, 299, 402, 301 '8R draw unless wall at block 0-7    

    select case ch$
      case "N"
        xt = x - 1 : yt = y - 8
      case "S"
        xt = x + 1 : yt = y + 8
      case "W"
        xt = x - 8 : yt = y + 1
      case "E"
        xt = x + 8 : yt = y - 1
    end select
    if maze$(xt, yt) <> wc$ then
      line 398, 299, 396, 299 '8TL
      line 398, 301, 396, 301 '8BL 
    endif

    select case ch$
      case "N"
        xt = x + 1 : yt = y - 8
      case "S"
        xt = x - 1 : yt = y + 8
      case "W"
        xt = x - 8 : yt = y - 1
      case "E"
        xt = x + 8 : yt = y + 1
    end select    
    if maze$(xt, yt) <> wc$ then
      line 402, 299, 404, 299 '8TR
      line 402, 301, 404, 301 '8BR    
    endif
  endif
  pause 200
end sub





















































